/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.actions;

import com.aptana.git.core.model.GitRepository;
import com.aptana.git.ui.dialogs.CreateBranchDialog;
import com.aptana.git.ui.internal.actions.AbstractGitHandler;
import com.aptana.git.ui.internal.actions.Messages;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class CreateBranchHandler
extends AbstractGitHandler {
    protected Object doExecute(ExecutionEvent event) throws ExecutionException {
        String startPoint;
        boolean track;
        String branchName;
        GitRepository theRepo = this.getSelectedRepository();
        if (theRepo == null && this.getSelectedResources() != null && this.getSelectedResources().isEmpty()) {
            this.openError(Messages.CommitAction_NoRepo_Title, Messages.CommitAction_NoRepo_Message);
            return null;
        }
        if (theRepo == null && this.getSelectedResources() != null && this.getSelectedResources().size() != 1) {
            this.openError(Messages.CommitAction_MultipleRepos_Title, Messages.CommitAction_MultipleRepos_Message);
            return null;
        }
        CreateBranchDialog dialog = new CreateBranchDialog(this.getShell(), theRepo);
        if (dialog.open() == 0 && theRepo.createBranch(branchName = dialog.getValue().trim(), track = dialog.track(), startPoint = dialog.getStartPoint())) {
            theRepo.switchBranch(branchName, (IProgressMonitor)new NullProgressMonitor());
        }
        return null;
    }
}

